using System;
using System.Collections.Generic;

class Program
{
    struct Vec
    {
        public long x, y;
        public double ang;
        public int idx;
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        var v = new List<Vec>();

        for (int i = 1; i <= n; i++)
        {
            var p = Console.ReadLine().Split();
            long x = long.Parse(p[0]);
            long y = long.Parse(p[1]);
            v.Add(new Vec {
                x = x,
                y = y,
                ang = Math.Atan2(y, x),
                idx = i
            });
        }

        v.Sort((a, b) => a.ang.CompareTo(b.ang));

        int m = v.Count;
        var vv = new Vec[2 * m];
        for (int i = 0; i < m; i++)
        {
            vv[i] = v[i];
            vv[i + m] = v[i];
            vv[i + m].ang += 2 * Math.PI;
        }

        long sx = 0, sy = 0;
        long best = 0;
        int bi = 0, bj = -1;

        int j = 0;
        for (int i = 0; i < m; i++)
        {
            while (j < i + m && vv[j].ang - vv[i].ang <= Math.PI)
            {
                sx += vv[j].x;
                sy += vv[j].y;
                j++;
            }

            long cur = sx * sx + sy * sy;
            if (cur > best)
            {
                best = cur;
                bi = i;
                bj = j - 1;
            }

            sx -= vv[i].x;
            sy -= vv[i].y;
        }

        var res = new List<int>();
        for (int i = bi; i <= bj; i++)
            res.Add(vv[i].idx);

        Console.WriteLine(res.Count);
        Console.WriteLine(string.Join(" ", res));
    }
}